/*
	File: CEG_client.sqf
	Version: 1.1
	Author: Loyalguard

	Description:
	A script to initialize all the required client-side components of the CEG simulation.

	Parameters:
	None.
	
	Execution:
	Executed from CEG_init.sqf.  Will only run on MP clients due to conditions checked in CEG_init.sqf.	
*/

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_client.sqf: Thread started"] call LGD_fnc_debugMessage;}; //DEBUG

// Scope //
private ["_obj"];

// Begin a forEach loop to create PVEHs on clients that will fire when the power status of a CEG object changes.
{
	// Assign a local variable to the first element extracted from the CEG_objects array in this iteration of the forEach loop.
	_obj = (_x select 0); // "objectName_location".
	
	// Pause loop to ensure that the public variable is created before the PVEH for that PV is.
	waitUntil {!(isNil (format ["CEG_on_%1", _obj]))};
	
	// Add the PVEH to the PV.  When the PVEH fires it will execute CEG_events.sqf and pass to it the name of PV and the new value.
	(format ["CEG_on_%1", _obj]) addPublicVariableEventHandler {[(_this select 0), (_this select 1)] execVM "CEG\Scripts\CEG_events.sqf"};

	sleep .01;

} forEach CEG_objects;  // CEG_objects was initialized in CEG_init.sqf.
	
// Execute the script CEG_common.sqf which has common code for required for SP, MP hosts, and MP clients but NOT required MP dedicated servers.
_nul = [] execVM "CEG\Scripts\CEG_common.sqf"; 

// If the machine is a JIP MP client (determined in CEG_init.sqf) then wait until the player has connected (is not null) and then execute CEG_JIP.sqf to ensure the client will have the current values for the public variables that stores the power status of each pertinent CEG Object.
if (CEG_JIP) then
{
	_debug = ["CEG_client.sqf: CEG_JIP returned true - player is:", player] call LGD_fnc_debugMessage; //DEBUG
	
	waitUntil {!(isNull player)};
	
	if (!isNil "CEG_DEBUG") then {_debug = ["CEG_client.sqf: isNull player wait complete - player now is:", player] call LGD_fnc_debugMessage;}; //DEBUG
	
	_nul = [] execVM "CEG\Scripts\CEG_JIP.sqf";
};

if (!isNil "CEG_DEBUG") then {_debug = ["CEG_client.sqf: Thread finished."] call LGD_fnc_debugMessage;}; //DEBUG